<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbmail');
define('IN_VBMAIL', true);

if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'ajax')
{
	define('CSRF_PROTECTION', true);
	define('LOCATION_BYPASS', 1);
	define('NOPMPOPUP', 1);
	define('VB_ENTRY', 'ajax.php');
	define('SESSION_BYPASS', true);
	define('VB_ENTRY_TIME', microtime(true));
}

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('dbtech_vbmail', 'user', 'album', 'posting');

// get templates used by all actions
$globaltemplates = array(
	'dbtech_vbmail',
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'main' => array(
		'dbtech_vbmail_mailinglist',
		'dbtech_vbmail_mailinglist_bit',
		'dbtech_vbmail_history',
		'dbtech_vbmail_history_bit',
		'dbtech_vbmail_sendmail',
		'dbtech_vbmail_sendmail_choosetemplate',
		'dbtech_vbmail_viewmail',
		'dbtech_vbmail_keywords',
		'dbtech_vbmail_keywords_bit',
		'optgroup',
	),
	'mailinglists' => array(
		'dbtech_vbmail_mailinglist',
		'dbtech_vbmail_mailinglist_bit',
		'dbtech_vbmail_history',
		'dbtech_vbmail_history_bit',
		'dbtech_vbmail_sendmail',
		'dbtech_vbmail_sendmail_choosetemplate',
		'dbtech_vbmail_viewmail',
		'dbtech_vbmail_keywords',
		'dbtech_vbmail_keywords_bit',
		'dbtech_vbmail_unsubscribe_feedback',
		'dbtech_vbmail_unsubscribe_feedback_bit',
		'optgroup',
	),
);

// get special data templates from the datastore
require('./dbtech/vbmail/includes/specialtemplates.php');
$specialtemplates = $extracache;
$specialtemplates[] = 'bbcodecache';

// ############################### default do value ######################
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = $_GET['do'] = 'main';
}
else if ($_REQUEST['do'] == 'mailinglists' AND $_REQUEST['action'] == 'sendmail')
{
	// Grab our editor templates
	define('GET_EDIT_TEMPLATES', true);
}

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

if (!class_exists('vB_Template'))
{
	// Ensure we have this
	require_once(DIR . '/dbtech/vbmail/includes/class_template.php');
}

if (!class_exists('VBMAIL'))
{
	eval(standard_error($vbphrase['dbtech_vbmail_deactivated']));
}



// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (!empty($_POST['do']))
{
	// $_POST requests take priority
	$action = $_POST['do'];
}
else if (!empty($_GET['do']))
{
	// We had a GET request instead
	$action = $_GET['do'];
}
else
{
	// No request
	$action = 'main';
}

// Strip non-valid characters
$action = preg_replace('/[^\w-]/i', '', $action);

if (!$vbulletin->options['dbtech_vbmail_active'])
{
	// Sb is shut off
	eval(standard_error($vbulletin->options['dbtech_vbmail_closedreason']));
}

if (VBMAIL::$permissions['isbanned'])
{
	// Can't view Activity
	print_no_permission();
}

// begin navbits
$navbits = array('vbmail.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['dbtech_vbmail_vbmail']);

// Core page template
$page_template = 'dbtech_vbmail';

if (!file_exists(DIR . '/dbtech/vbmail/actions/' . $action . '.php'))
{
	if (!file_exists(DIR . '/dbtech/vbmail_pro/actions/' . $action . '.php'))
	{
		// Throw error from invalid action
		eval(standard_error(fetch_error('dbtech_vbmail_error_x', $vbphrase['dbtech_vbmail_invalid_action'])));
	}
	else
	{
		// Include the selected file
		include_once(DIR . '/dbtech/vbmail_pro/actions/' . $action . '.php');	
	}
}
else
{
	// Include the selected file
	include_once(DIR . '/dbtech/vbmail/actions/' . $action . '.php');	
}

if (intval($vbulletin->versionnumber) == 3)
{
	// Create navbits
	$navbits = construct_navbits($navbits);	
	eval('$navbar = "' . fetch_template('navbar') . '";');
}
else
{
	$navbar = render_navbar_template(construct_navbits($navbits));	
}

if (intval($vbulletin->versionnumber) == 3)
{
	// Begin the monster template
	$headinclude .= vB_Template::create('dbtech_vbmail.css')->render();
}

// Finish the main template
$templater = vB_Template::create($page_template);
	$templater->register_page_templates();
	$templater->register('navclass', 		$navclass);
	$templater->register('HTML', 			$HTML);
	$templater->register('navbar', 			$navbar);
	$templater->register('pagetitle', 		$pagetitle);
	$templater->register('pagedescription', $pagedescription);
	$templater->register('template_hook', 	$template_hook);
	$templater->register('includecss', 		$includecss);
	$templater->register('year',			date('Y'));
	$templater->register('jQueryVersion',	VBMAIL::$jQueryVersion);
	$templater->register('jQueryPath',		VBMAIL::jQueryPath());
	$templater->register('version',			'2.1.3 Patch Level 1');
	$templater->register('versionnumber', 	'213pl1');
	$templater->register('headinclude', 	$headinclude);
print_output($templater->render());